INCLUDE "GLOBALS"

DIM output_string AS STRING ( 10 )

output_string = "0123456789"

estopped = NOT IN(input_estopon)
DIM estopstateon AS BOOLEAN

DIM startingup AS BOOLEAN
startingup = TRUE

DIM reverseestop AS BOOLEAN
reverseestop = (VR(vr_machine) = micromillpro) OR (VR(vr_machine) = microturnpro)

REPEAT
    WA(100)

    'The input is on when out and zero when in. (So estopstateon being false actually means its pushed in)
    estopstateon = IN(input_estopon)
    'ON microturn AND micromill, the estop is reversed
    IF reverseestop THEN
        estopstateon = NOT estopstateon
    ENDIF
    IF (estopstateon <> estopped) AND NOT startingup THEN
        CONTINUE
    ENDIF

    'To check that its not static, read it again after 500ms, and then only do something is the button state is the
'same as the previous state.
    WA(500)

    estopstateon = IN(input_estopon)

    'ON microturn AND micromill, the estop is reversed
    IF reverseestop THEN
        estopstateon = NOT estopstateon
    ENDIF

    IF (estopstateon = estopped) OR startingup THEN
        IF estopstateon = FALSE THEN
            estopped = TRUE
            'EStop pressed. Stop all axes etc
            DIM n AS INTEGER
            FOR n=0 TO 2
                BASE(n)
                CANCEL(2)
            NEXT n

            spindlestop()

            OP(output_guardlock,OFF)
            CHANNEL_WRITE(5,output_string)
            TABLE(table_estoppressed, ON)
            TABLE(table_guardunlock, ON)
            OP(output_zbrakerelease,OFF)

            TABLE(comms_estopstate,ON)
            raiseevent(comms_estopstate)


        ELSE
            estopped = FALSE
            'Estop was previously pressed. Restore everything is it is safe
            OP(output_zbrakerelease,ON)
            WA(1000)
            TABLE(table_estoppressed, OFF)

            TABLE(comms_estopstate,OFF)
            raiseevent(comms_estopstate)
            WA(7000)
            OP(output_guardlock,ON)
            TABLE(table_guardunlock, OFF)

        ENDIF
    ENDIF

    IF startingup THEN
        startingup = FALSE
        TABLE(table_startingup, TABLE(table_startingup) OR 1)
    ENDIF

UNTIL FALSE
